--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A faction game object.
--- @class tes3faction : tes3baseObject
--- @field attributes tes3.attribute[] *Read-only*. An array-style table holding the two attributes that govern advancement. Maps to values in [`tes3.attribute`](https://mwse.github.io/MWSE/references/attributes/) namespace.
--- @field name string The faction's player-facing name.
--- @field playerExpelled boolean The player's expelled state in the faction. You should prefer to use the `expel` or `clearExpel` functions to modify this, to ensure the changes are visible to all systems.
--- @field playerJoined boolean The player's join state for the faction. You should prefer to use the `join` or `leave` functions to modify this, to ensure the changes are visible to all systems.
--- @field playerRank number The player's current rank in the faction.
--- @field playerReputation number The player's current reputation in the faction.
--- @field ranks tes3factionRank[] *Read-only*. An array-style table holding the ten related [`tes3factionRank`](https://mwse.github.io/MWSE/types/tes3factionRank/)s.
--- @field reactions tes3factionReaction[] *Read-only*. A collection of [`tes3factionReaction`](https://mwse.github.io/MWSE/types/tes3factionReaction/)s.
--- @field skills tes3.skill[] *Read-only*. An array-style table holding the seven skills that govern advancement. Maps to values in [`tes3.skill`](https://mwse.github.io/MWSE/references/skills/) namespace.
tes3faction = {}

--- Clears the expulsion of the player from this faction. It also ensures the character sheet UI is updated.
--- @return boolean success No description yet available.
function tes3faction:clearExpel() end

--- Demotes the player to the previous rank of this faction, if they are a member. It does not automatically make the player leave the faction if demoted too far. It also ensures the character sheet UI is updated.
--- @return boolean success No description yet available.
function tes3faction:demote() end

--- Expels the player from this faction. It displays a message box notifying the player that they are expelled. It also ensures the character sheet UI is updated.
--- @return boolean success No description yet available.
function tes3faction:expel() end

--- For this faction, this function finds the best reaction for another faction that the player has joined. It returns that reaction and its associated faction, or `nil` for both values if the no relationship is applicable.
--- @return number|nil reaction The reaction, if any, that is best for the faction.
--- @return tes3faction|nil faction The faction association, if any, that is best for the faction.
function tes3faction:getHighestJoinedReaction() end

--- For this faction, this function finds the worst reaction for another faction that the player has joined. It returns that reaction and its associated faction, or `nil` for both values if the no relationship is applicable.
--- @return number|nil reaction The reaction, if any, that is worst for the player.
--- @return tes3faction|nil faction The faction association, if any, that is worst for the player.
function tes3faction:getLowestJoinedReaction() end

--- This function fetches the player-facing name of a rank in the faction.
--- @param rank number A rank number in range [0, 9] inclusive.
--- @return string result No description yet available.
function tes3faction:getRankName(rank) end

--- Returns a reaction value for another faction, or `nil` if no relationship exists between the two factions.
--- @param faction tes3faction Another faction to get a reaction for.
--- @return number|nil reaction The reaction, if any, with the other faction.
function tes3faction:getReactionWithFaction(faction) end

--- Makes the player join this faction. It also ensures the character sheet UI is updated.
--- @return boolean success No description yet available.
function tes3faction:join() end

--- Makes the player leave this faction. It also ensures the character sheet UI is updated.
--- @return boolean success No description yet available.
function tes3faction:leave() end

--- Promotes the player to the next rank of this faction, if they are a member. It does not automatically make the player join the faction. It also ensures the character sheet UI is updated.
--- @return boolean success No description yet available.
function tes3faction:promote() end

--- This function changes the player-facing name of a given rank in the faction.
--- @param rank number A rank number in range [0, 9] inclusive.
--- @param name string A new name to set.
function tes3faction:setRankName(rank, name) end

